#import "MainMenuController.h"
#import "unistd.h"

@implementation MainMenuController

- (id)init
{
    [super init];
    
    mKextLock = [[NSLock alloc] init];
    
    return self;
}

- (void)delegate
{
    [mKextLock release];
}

- (void)awakeFromNib
{
    mFinishedLaunching = NO;
    
    [NSApp setDelegate:self];
    
    if( ![[NSUserDefaults standardUserDefaults] stringForKey:@"pathToToastImageMounter"] || ![[NSFileManager defaultManager] fileExistsAtPath:[[NSUserDefaults standardUserDefaults] stringForKey:@"pathToToastImageMounter"]] ) {
	[self locateToast];
    }
    
    [self checkForUpdate:nil];
    [self kernelExtensionInstalled];
}

#pragma mark -

- (IBAction)checkForUpdate:(id)sender
{
    NSString *latest = [NSString stringWithContentsOfURL:[NSURL URLWithString:@"http://toastmount.sourceforge.net/latest.txt"]];

    if ((!latest || [latest isEqualToString:@""]) && sender) {
        // failed to check for update
        NSRunAlertPanel(NSLocalizedString(@"Could not check for updates", nil), NSLocalizedString(@"Could not check for the latest version. Make sure you're connected to the internet.", nil), NSLocalizedString(@"OK", nil), nil, nil);
    }
    
    if (!latest || [latest isEqualToString:@""]) {
        return;
    }
    
    if (![latest isEqualToString:[[NSBundle mainBundle] objectForInfoDictionaryKey:@"CFBundleVersion"]]) {
        int returnCode = NSRunAlertPanel(NSLocalizedString(@"Update available", nil), NSLocalizedString(@"A new version of ToastMount is available.", nil), NSLocalizedString(@"More Info...", nil), NSLocalizedString(@"Ignore", nil), nil);
        if (returnCode == NSAlertDefaultReturn) {
            [[NSWorkspace sharedWorkspace] openURL:[NSURL URLWithString:@"http://toastmount.sourceforge.net/downloads.php"]];
        }
        return;
    }
    
    if (sender) {
        NSRunAlertPanel(NSLocalizedString(@"No Update Available", nil), NSLocalizedString(@"You have the latest version of ToastMount.", nil), NSLocalizedString(@"OK", nil), nil, nil);
    }
}

- (IBAction)open:(id)sender
{
    NSOpenPanel *panel = [NSOpenPanel openPanel];
    
    [panel setAllowsMultipleSelection:YES];
    [panel setCanChooseDirectories:NO];
    [panel setCanChooseFiles:YES];
    
    [panel beginForDirectory:NSHomeDirectory() file:nil types:[NSArray arrayWithObjects:@"iso", nil] modelessDelegate:self didEndSelector:@selector(openPanelDidEnd:returnCode:contextInfo:) contextInfo:nil];
    
    [panel retain];
}

#pragma mark -

- (void)addSubview:(NSView *)aView
{
    if (!aView) {
        return;
    }
    
    [[window contentView] addSubview:aView];
    [aView setFrameOrigin:NSMakePoint(0,([[[window contentView] subviews] count]-1)*[aView frame].size.height)];
    
    [window setFrame:NSMakeRect([window frame].origin.x, [window frame].origin.y-[aView frame].size.height, [aView frame].size.width, [[[window contentView] subviews] count]*[aView frame].size.height+20) display:YES];
    
    [window makeKeyAndOrderFront:self];
}

- (void)application:(NSApplication *)sender openFiles:(NSArray *)filenames
{
    if (!mFinishedLaunching) {
        mDropLaunch = YES;
    }
    
    NSEnumerator *enumerator = [filenames objectEnumerator];
    NSString *file;
    MountController *newNib;
    while( file = [enumerator nextObject] )
    {
        newNib = [[MountController alloc] init];
        if (![NSBundle loadNibNamed:@"Mount" owner:newNib]) {
            NSLog(@"Error loading Mount.nib");
        }
        else {
            [newNib setDelegate:self];
            [self addSubview:[newNib view]];
            //[[NSThread detachNewThreadSelector:@selector(loadImage:) toTarget:newNib withObject:file] retain];
            [newNib loadImage:file];
        }
    }
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
    mFinishedLaunching = YES;
}

- (void)checkToastAtPath:(NSString *)aPath
{
    if( [[NSFileManager defaultManager] fileExistsAtPath:[[aPath stringByDeletingLastPathComponent] stringByAppendingPathComponent:@"MacOS/ToastImageMounter"]] )
    {
	NSLog(@"Found ToastImageMounter at %@",[[aPath stringByDeletingLastPathComponent] stringByAppendingPathComponent:@"MacOS/ToastImageMounter"]);
	[[NSUserDefaults standardUserDefaults] setObject:[[aPath stringByDeletingLastPathComponent] stringByAppendingPathComponent:@"MacOS/ToastImageMounter"] forKey:@"pathToToastImageMounter"];
        
	return;
    }
    else if( [[NSFileManager defaultManager] fileExistsAtPath:[aPath stringByAppendingPathComponent:@"Contents/MacOS/ToastImageMounter"]] )
    {
	NSLog(@"Found ToastImageMounter at %@",[aPath stringByAppendingPathComponent:@"Contents/MacOS/ToastImageMounter"]);
	[[NSUserDefaults standardUserDefaults] setObject:[aPath stringByAppendingPathComponent:@"Contents/MacOS/ToastImageMounter"] forKey:@"pathToToastImageMounter"];

	return;
    }

    NSRunCriticalAlertPanel(NSLocalizedString(@"Could not find Toast", nil), NSLocalizedString(@"Please install Toast before using ToastMount.", nil), NSLocalizedString(@"Quit", nil), nil, nil);
    [NSApp terminate:self];
}

- (void)kernelExtensionInstalled
{
    BOOL installed = TRUE;
    
    if (![[NSFileManager defaultManager] fileExistsAtPath:@"/Library/Application Support/Roxio/TDIXSupport"]) {
        installed = FALSE;
    }
    
    if (![[NSFileManager defaultManager] fileExistsAtPath:@"/Library/Application Support/Roxio/TDIXController.kext"]) {
        installed = FALSE;
    }
    
    if (!installed) {
        NSRunCriticalAlertPanel(NSLocalizedString(@"Extensions Not Found", nil), NSLocalizedString(@"You need to launch Toast and load a image once, before you can use ToastMount!", nil), NSLocalizedString(@"Quit", nil), nil, nil);
        [NSApp terminate:self];
    }
}

- (BOOL)kernelExtensionLoaded
{
    NSTask* kextTask;
    NSPipe* kextPipe;
    NSString* kextOutput;
    
    kextTask = [[NSTask alloc] init];
    kextPipe = [[NSPipe alloc] init];
    [kextTask setLaunchPath:@"/usr/sbin/kextstat"];
    [kextTask setArguments:[NSArray arrayWithObjects:@"-l", @"-b", @"com.roxio.TDIXController", nil]];
    [kextTask setStandardOutput:kextPipe];
    [kextTask launch];

    while( [kextTask isRunning] ) {
        sleep(0.5);
    }

    kextOutput = [[NSString alloc] initWithData:[[kextPipe fileHandleForReading] availableData] encoding:NSASCIIStringEncoding];
    if( strstr([kextOutput cString], "com.roxio.TDIXController") != NULL ) {
        return YES;
    } else {
        return NO;
    }
}

- (void)loadKernelExtension
{
    if ([self kernelExtensionLoaded]) {
        return;
    }
    
    [mKextLock lock];
    
    if ([self kernelExtensionLoaded]) {
        [mKextLock unlock];
        return;
    }
        
    NSTask *kextTask;
    kextTask = [[NSTask alloc] init];
    [kextTask setLaunchPath:@"/Library/Application Support/Roxio/TDIXSupport"];
    [kextTask setArguments:[NSArray arrayWithObject:@"/Library/Application Support/Roxio/TDIXController.kext"]];
    [kextTask launch];
        
    while( [kextTask isRunning] ) {
        sleep(0.5);
    }
        
    if( ![self kernelExtensionLoaded] ) {
        NSRunCriticalAlertPanel(NSLocalizedString(@"Failed to load the system extension", nil), NSLocalizedString(@"Something went wrong while trying to load the extension. ToastMount cannot be used without it.", nil), NSLocalizedString(@"Quit", nil), nil, nil);
        [NSApp terminate:self];
    }
        
    [mKextLock unlock];
}

- (void)locateToast
{
    NSString *pathToToast = pathToToast = [[NSWorkspace sharedWorkspace] fullPathForApplication:@"Toast 6 Titanium"];
    
    if( pathToToast ) {
	[self checkToastAtPath:pathToToast];
	return;
    }

    int panelReturnCode = NSRunAlertPanel(NSLocalizedString(@"Toast not found", nil), NSLocalizedString(@"Please install Toast before using ToastMount. If you have Toast installed, please select the application.", nil), NSLocalizedString(@"Select Toast...", nil), NSLocalizedString(@"Quit", nil), nil);
    
    if( panelReturnCode == NSAlertAlternateReturn || panelReturnCode == NSAlertErrorReturn ) {
        [NSApp terminate:nil];
    }

    NSOpenPanel *panel = [NSOpenPanel openPanel];
    [panel runModalForDirectory:@"/Applications" file:nil types:[NSArray arrayWithObject:@"app"]];
    if ([[panel filenames] count] == 0) {
        [NSApp terminate:self];
    }
    [self checkToastAtPath:[[panel filenames] objectAtIndex:0]];
}

- (void)openPanelDidEnd:(NSOpenPanel *)sheet returnCode:(int)returnCode contextInfo:(void *)contextIn
{
    [self application:NSApp openFiles:[sheet filenames]];
    
    [sheet release];
}

- (void)removeSubview:(NSView *)aView
{
    if (!aView) {
        return;
    }
    
    [aView removeFromSuperview];
    
    int i;
    for(i=0; i<[[[window contentView] subviews] count]; i++) {
        [[[[window contentView] subviews] objectAtIndex:i] setFrameOrigin:NSMakePoint(0,i*[aView frame].size.height)];
    }
    
    [window setFrame:NSMakeRect([window frame].origin.x, [window frame].origin.y+[aView frame].size.height, [window frame].size.width, ([[[window contentView] subviews] count])*[aView frame].size.height+20) display:YES];

    if ([[[window contentView] subviews] count] == 0) {
        [window orderOut:self];
        if (mDropLaunch) {
            [NSApp terminate:self];
        }
    }
}

@end
